
#ifndef SRAM_H
#define	SRAM_H

#ifdef	__cplusplus
extern "C" {
#endif

void SRAMSetup(void);
unsigned char IsSRAMBusy(void);
void RAMtoSRAMCopy(const void* src, unsigned long destaddr, unsigned long numbytes);
void SRAMtoRAMCopy(unsigned long srcaddr, void* dest, unsigned long numbytes);
unsigned char TestSRAM(unsigned char* buffer, unsigned long size); // 0 = success
void EraseSRAM(unsigned char* buffer, unsigned long size);

//void SRAMPMPSetup(void);
unsigned char SRAMReadByte(unsigned long Address, unsigned char pulldown);
void SRAMWriteByte(unsigned long Address, unsigned char data);

#ifdef	__cplusplus
}
#endif

#endif	/* SRAM_H */

